from xmlparser import *
import string
import sys

# Extract another view from a simple overlapped markup scheme.
# This program focuses on the narrative vs. spoken text.
# In this view, verse boundaries can occur anywhere.

verse = 0

def processText (token):
   global verse
   for token in token.children ():
      if token.isStartElement ("sVerse"):
         verse += 1
         sys.stdout.write (" [" + str (verse) + "] ")
      elif token.isStartElement ("sQuote"):
         quoteChar = "'"
         if token.attrs.has_key ("speaker") and \
               token.attrs ["speaker"].value == "Jesus":
            quoteChar = "\""
         sys.stdout.write ("\n\n" + quoteChar)
         for token in token.children ("", "eQuote"):
            if token.isCharacters ():
               sys.stdout.write (token.characters)
            elif token.isEndElement ("sVerse"):
               verse += 1
               sys.stdout.write (" [" + str (verse) + "] ")
               pass
         sys.stdout.write (quoteChar + "\n\n")
      elif token.isCharacters ():
         sys.stdout.write (token.characters)

for token in anXMLParser (documentEntity = sys.stdin) ():
   if token.isStartElement ("sample"):
      processText (token)
sys.stdout.write ("\n")
