# Module patchedout

# An alternative to writing to a file or other writable output.
# See xmlparser.html for how to use this module.

class patchedoutput:
   def __init__ (self, destination):
      """
         Create a patchedoutput. "destination" must be a writable
         destination like a file object.
      """
      self.destination = destination
      self.buffer = []
      self.dictionary = {}
   def write (self, text):
      """
         Write text to the destination.
      """
      if len (self.buffer) > 0:
         self.buffer.append (text)
      elif type (text) == type ([]):
         for textItem in text:
            self.write (textItem)
      else:
         self.destination.write (text)
   def writePatch (self, label):
      """
         Write a possibly undefined label to the destination.
      """
      if self.dictionary.has_key (label) and len (self.buffer) == 0:
         self.destination.write (self.dictionary [label])
      else:
         self.buffer.append ([label])
   def setPatch (self, label, text):
      """
         Define a label that may or may not be written to the desination.
      """
      self.dictionary [label] = text
      while True:
         if len (self.buffer) == 0:
            break
         elif type (self.buffer [0]) != type ([]):
            self.destination.write (self.buffer.pop (0))
         elif self.dictionary.has_key (self.buffer [0] [0]):
            self.destination.write (self.buffer.pop (0) [0])
         else:
            break
   def getUndefined (self):
      """
         Get a list of the labels written to the destination that
         haven't yet been defined.
      """
      for unwritten in self.buffer:
         if type (unwritten) == type ([]) and \
               not self.dictionary.has_key (unwritten [0]):
            yield unwritten [0]
   def close (self):
      """
        Just close the destination.
      """
      self.destination.close ()
