# Module xmlpatterns -- support for a pattern-matching approach to
# processing XML

from patterns_nb import *
from xmlparser import *

import sys

class xmlParserReader:
   """
      A re-encapsulation of anXMLParser as a file-like object.
   """
   def __init__ (self, parser, options = ""):
      self.reader = parser (options + "ZW")
   def read (self, count):
      result = []
      try:
         while True:
            oneToken = self.reader.next ()
            result.append (oneToken)
            if len (result) >= count:
               break
      except StopIteration:
         pass
      return result
   def close (self):
      pass

def getToken (subject):
   """
      Should only be used by the following pattern implementations.
   """
   if subject.AtTheEnd ():
      return markupToken ()
   else:
      subject.Pos += 1
      return subject.Buffer [subject.Pos - subject.Offset - 1]

class xmlCharactersP (Pattern):
   """
      Match a character XML token.
   """
   def Match (self, subject):
      return getToken (subject).isCharacters ()

class xmlEndDocumentP (Pattern):
   """
      Match an end document XML token.
   """
   def Match (self, subject):
      return getToken (subject).isEndDocument ()

class xmlEndElementP (Pattern):
   """
      Match an end element XML token.
   """
   def Match (self, subject):
      return getToken (subject).isEndElement (*self.names)
   def __init__ (self, *names):
      self.names = names

class xmlIgnorableWhitespaceP (Pattern):
   """
      Match an ignorable whitespace XML token.
   """
   def Match (self, subject):
      return getToken (subject).isIgnorableWhitespace ()

class xmlProcessingInstructionP (Pattern):
   """
      Match a processing instruction XML token.
   """
   def Match (self, subject):
      return getToken (subject).isProcessingInstruction (*self.targets)
   def __init__ (self, *targets):
      self.targets = targets

class xmlSetDocumentLocatorP (Pattern):
   """
      Match a set document locator XML token.
   """
   def Match (self, subject):
      return getToken (subject).isSetDocumentLocator ()

class xmlSkippedEntityP (Pattern):
   """
      Match a skipped entity XML token.
   """
   def Match (self, subject):
      return getToken (subject).isSkippedEntity (*self.names)
   def __init__ (self, *names):
      self.names = names

class xmlStartDocumentP (Pattern):
   """
      Match a start document XML token.
   """
   def Match (self, subject):
      return getToken (subject).isStartDocument ()

class xmlStartElementP (Pattern):
   """
      Match a start element XML token.
   """
   def Match (self, subject):
      return getToken (subject).isStartElement (*self.names)
   def __init__ (self, *names):
      self.names = names

class xmlExceptionP (Pattern):
   """
      Match an exception XML token.
   """
   def Match (self, subject):
      return getToken (subject).isException (*self.severities)
   def __init__ (self, *severities):
      self.severities = severities

class xmlEntityP (Pattern):
   """
      Match a resolvable entity XML token.
   """
   def Match (self, subject):
      return getToken (subject).isEntity (*self.names)
   def __init__ (self, *names):
      self.names = names

class xmlNotationDeclP (Pattern):
   """
      Match a notation declaration XML token.
   """
   def Match (self, subject):
      return getToken (subject).isNotationDecl (*self.names)
   def __init__ (self, *names):
      self.names = names

class xmlUnparsedEntityDeclP (Pattern):
   """
      Match an unparsed entity declaration XML token.
   """
   def Match (self, subject):
      return getToken (subject).isUnparsedEntityDecl (*self.names)
   def __init__ (self, *names):
      self.names = names

class xmlTheBeginingP (Pattern):
   """
      Match a "the begining"  XML token.
   """
   def Match (self, subject):
      return getToken (subject).isTheBegining ()

class xmlTheEndP (Pattern):
   """
      Match a "the end" XML token.
   """
   def Match (self, subject):
      return getToken (subject).isTheEnd ()
